<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\FacilityCategory;
use Morilog\Jalali\Jalalian;

class DashboardController extends Controller
{
    public function userDashboard(Request $request)
    {
        $user = auth()->user();

        // آمار کلی درخواست‌ها
        $requests_total = DB::table('requests')->where('user_id', $user->id)->count();
        $requests_approved = DB::table('requests')->where('user_id', $user->id)->where('status', 'approved')->count();
        $requests_pending = DB::table('requests')->where('user_id', $user->id)->where('status', 'pending')->count();
        $requests_rejected = DB::table('requests')->where('user_id', $user->id)->where('status', 'rejected')->count();

        // لیست ۳ درخواست اخیر با تاریخ شمسی
        $recent_requests = DB::table('requests')
            ->join('places', 'requests.place_id', '=', 'places.id')
            ->where('requests.user_id', $user->id)
            ->orderBy('requests.created_at', 'desc')
            ->select(
                'requests.id',
                'requests.status',
                'places.name as place_name',
                'requests.created_at'
            )
            ->limit(3)
            ->get()
            ->map(function ($item) {
                $item->created_at_jalali = Jalalian::fromDateTime($item->created_at)->format('Y/m/d');
                return $item;
            })
            ->values();

        // آمار ماهانه ورود و خروج کاربر بر اساس ماه شمسی
        $all_entries = DB::table('entries')
            ->where('user_id', $user->id)
            ->select('entry_type', 'created_at')
            ->get();
        $categories = FacilityCategory::all();

        // ماه‌های شمسی
        $months_fa = [
            1 => 'فروردین', 2 => 'اردیبهشت', 3 => 'خرداد', 4 => 'تیر',
            5 => 'مرداد', 6 => 'شهریور', 7 => 'مهر', 8 => 'آبان',
            9 => 'آذر', 10 => 'دی', 11 => 'بهمن', 12 => 'اسفند'
        ];

        // مقداردهی اولیه آرایه خروجی
        $entry_chart = [];
        for ($m = 1; $m <= 12; $m++) {
            $entry_chart[$m] = [
                'month' => $months_fa[$m],
                'entry_count' => 0,
                'exit_count' => 0
            ];
        }

        // جمع‌بندی ورود/خروج ماه شمسی
        foreach ($all_entries as $item) {
            $jalali = Jalalian::fromDateTime($item->created_at);
            $month = intval($jalali->getMonth());
            if ($item->entry_type === 'entry') {
                $entry_chart[$month]['entry_count']++;
            }
            if ($item->entry_type === 'exit') {
                $entry_chart[$month]['exit_count']++;
            }
        }

        // خروجی نهایی به صورت آرایه (نه map) برای فرانت اند
        $chart_data = array_values($entry_chart);

        return response()->json([
            'profile' => [
                'full_name' => $user->full_name ?? '',
                'mobile_number' => $user->mobile_number ?? $user->mobile ?? null,
                'avatar' => $user->avatar ?? null,
            ],
            'stats' => [
                'requests_total' => $requests_total,
                'requests_approved' => $requests_approved,
                'requests_pending' => $requests_pending,
                'requests_rejected' => $requests_rejected,
            ],
            'recent_requests' => $recent_requests,
            'entry_chart' => $chart_data,
            'categories' => $categories,
        ]);
    }
}
