<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FacilityCategory;

class FacilityCategoryController extends Controller
{
    /**
     * دریافت لیست تمام دسته‌بندی‌ها
     */
    public function index()
    {
        $categories = FacilityCategory::all();
        return response()->json($categories, 200);
    }

    /**
     * ایجاد یک دسته‌بندی جدید
     */
    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|unique:facility_categories,name',
            'description' => 'nullable|string',
        ]);

        $category = FacilityCategory::create($validated);

        return response()->json(['message' => 'دسته‌بندی جدید ایجاد شد.', 'data' => $category], 201);
    }

    /**
     * ویرایش یک دسته‌بندی
     */
    public function update(Request $request, $id)
    {
        $category = FacilityCategory::findOrFail($id);

        $validated = $request->validate([
            'name' => 'required|string|unique:facility_categories,name,' . $id,
            'description' => 'nullable|string',
        ]);

        $category->update($validated);

        return response()->json(['message' => 'دسته‌بندی با موفقیت ویرایش شد.', 'data' => $category], 200);
    }

    /**
     * حذف یک دسته‌بندی (در صورت نبود مکان مرتبط)
     */
    public function destroy($id)
    {
        $category = FacilityCategory::findOrFail($id);

        // بررسی اگر دسته‌بندی دارای مکان مرتبط است، اجازه حذف ندهد
        if ($category->places()->exists()) {
            return response()->json(['message' => 'این دسته‌بندی دارای مکان‌های مرتبط است و قابل حذف نیست.'], 400);
        }

        $category->delete();

        return response()->json(['message' => 'دسته‌بندی حذف شد.'], 200);
    }
}
