<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Operator;
use App\Models\Place;
use App\Models\Request as UserRequest;
use App\Models\Entry;
use Carbon\Carbon;

class OperatorDashboardController extends Controller
{
    public function stats(Request $request)
    {
        $place_id = $request->input('place_id'); // از query string می‌گیرد

        // 1. کارت‌های آمار سریع
        $totalUsers = User::count();
        $totalOperators = Operator::count();
        $totalPlaces = Place::count();
        $today = Carbon::today();

        // اعمال فیلتر مکان بر آمار امروز
        $entryTodayQuery = Entry::where('entry_type', 'entry')->whereDate('created_at', $today);
        $exitTodayQuery  = Entry::where('entry_type', 'exit')->whereDate('created_at', $today);
        if ($place_id) {
            $entryTodayQuery->where('place_id', $place_id);
            $exitTodayQuery->where('place_id', $place_id);
        }
        $entriesToday = $entryTodayQuery->count();
        $exitsToday   = $exitTodayQuery->count();

        $pendingRequests = UserRequest::where('status', 'pending');

        $pendingRequests = $pendingRequests->count();

        // 2. نمودار ورود/خروج 7 روز اخیر (هر روز تعداد)
        $chartData = [];
        for ($i = 6; $i >= 0; $i--) {
            $date = Carbon::today()->subDays($i)->toDateString();
            $entryChartQuery = Entry::where('entry_type', 'entry')->whereDate('created_at', $date);
            $exitChartQuery  = Entry::where('entry_type', 'exit')->whereDate('created_at', $date);
            if ($place_id) {
                $entryChartQuery->where('place_id', $place_id);
                $exitChartQuery->where('place_id', $place_id);
            }
            $chartData[] = [
                'date' => $date,
                'entries' => $entryChartQuery->count(),
                'exits' => $exitChartQuery->count(),
            ];
        }

        // 3. جدول خلاصه آخرین رویدادها (10 مورد آخر)
        $lastEventsQuery = Entry::with(['user:id,full_name', 'place:id,name'])
            ->orderBy('created_at', 'desc');
        if ($place_id) {
            $lastEventsQuery->where('place_id', $place_id);
        }
        $lastEvents = $lastEventsQuery->take(10)->get()->map(function($e) {
            return [
                'id' => $e->id,
                'user_name' => $e->user->full_name ?? '-',
                'place_name' => $e->place->name ?? '-',
                'entry_type' => $e->entry_type,
                'entry_time' => $e->entry_time,
            ];
        });

        return response()->json([
            'total_users' => $totalUsers,
            'total_operators' => $totalOperators,
            'total_places' => $totalPlaces,
            'entries_today' => $entriesToday,
            'exits_today' => $exitsToday,
            'pending_requests' => $pendingRequests,
            'chart' => $chartData,
            'last_events' => $lastEvents,
        ]);
    }

}
