<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class User extends Authenticatable implements JWTSubject
{
    use Notifiable;

    protected $fillable = [
        'full_name',
        'personnel_code',
        'mobile_number',
        'device_id',
        'is_active'
    ];
    public function requests()
    {
        return $this->hasMany(Request::class, 'user_id');
    }

    // متدهای موردنیاز JWT
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
}
