<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('entries', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('place_id')->constrained('places')->onDelete('cascade');
            $table->foreignId('qr_code_id')->constrained('temporary_qr_codes')->onDelete('cascade');
            $table->timestamp('entry_time')->default(now());
            $table->timestamp('exit_time')->nullable();
            $table->string('entry_type');
            $table->timestamps();

            $table->unique('qr_code_id');
        });
    }

    public function down()
    {
        Schema::dropIfExists('entries');
    }
};

