<?php


namespace App\Http\Controllers;

use App\Models\User;
use App\Models\ReferenceUser;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends Controller
{
    public function register(Request $request)
    {
        // اعتبارسنجی ورودی‌ها
        $validator = Validator::make($request->all(), [
            'personnel_code' => 'required|exists:reference_users,personnel_code|unique:users,personnel_code',
            'mobile_number' => 'required|exists:reference_users,mobile_number|unique:users,mobile_number',
            'device_id' => 'required|unique:users,device_id',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        // پیدا کردن اطلاعات کاربر در جدول مرجع `reference_users`
        $referenceUser = ReferenceUser::where('personnel_code', $request->personnel_code)
            ->where('mobile_number', $request->mobile_number)
            ->first();

        if (!$referenceUser) {
            return response()->json(['message' => 'User not authorized for registration'], 403);
        }

        // ایجاد حساب کاربری جدید در جدول `users`
        $user = User::create([
            'full_name' => $referenceUser->full_name, // مقداردهی صحیح `full_name`
            'personnel_code' => $request->personnel_code,
            'mobile_number' => $request->mobile_number,
            'device_id' => $request->device_id,
            'is_active' => false,
        ]);

        // ایجاد توکن JWT برای کاربر
        $token = JWTAuth::fromUser($user);

        return response()->json(['message' => 'User registered successfully', 'token' => $token, 'user' => $user]);
    }
    public function login(Request $request)
    {
        // اعتبارسنجی ورودی‌ها
        $validator = Validator::make($request->all(), [
            'mobile_number' => 'required|exists:users,mobile_number',
            'device_id' => 'required|exists:users,device_id',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        // بررسی کاربر در دیتابیس
        $user = User::where('mobile_number', $request->mobile_number)
            ->where('device_id', $request->device_id)
            ->first();

        if (!$user) {
            return response()->json(['message' => 'Unauthorized'], 401);
        }

        // بررسی وضعیت فعال بودن
        if (!$user->is_active) {
            return response()->json(['message' => 'Account not active. Please contact the admin.'], 403);
        }

        // ایجاد توکن JWT
        $token = JWTAuth::fromUser($user);

        return response()->json([
            'message' => 'Login successful',
            'token' => $token,
            'user' => $user
        ]);
    }

    public function me()
    {
        return response()->json(auth()->user());
    }
    public function logout()
    {
        auth()->logout();
        return response()->json(['message' => 'Logged out successfully']);
    }

}


