<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\TemporaryQrCode;
use App\Models\Operator;
use Illuminate\Support\Facades\DB;

class FacilityManagerController extends Controller
{
    public function showQrCodes($place_id)
    {
        $user = auth()->user();

        // 📌 بررسی نقش اپراتور بر اساس user_id (اصلاح شده)
        $operator = Operator::where('id', $user->id)->first();

        if (!$operator) {
            return response()->json(['message' => 'دسترسی غیرمجاز.'], 403);
        }

        // ✅ مدیر سیستم: مشاهده تمام QR Code های مکان
        if ($operator->role === 'system_operator') {
            $qrCodes = DB::table('temporary_qr_codes as q')
                ->join('places AS p', 'q.place_id', '=', 'p.id')      // اولین Inner Join
                ->join('users AS u', 'q.user_id', '=', 'u.id')

                ->select(
                    'q.id',
                    'q.code',
                    'q.is_used',
                    'q.expires_at',
                    'p.name AS place_name',   // نام مکان
                    'u.full_name AS user_name'     // نام کاربر
                )
                ->where('q.place_id', $place_id)
                ->where('q.is_used', false)
                ->where('q.expires_at', '>', now())
                ->get();

            return response()->json($qrCodes);
        }

        // ✅ مدیر مکان: مشاهده QR Code های مکان خود
        if ($operator->role === 'facility_operator' && $operator->place_id == $place_id) {
            $qrCodes = DB::table('temporary_qr_codes AS q')
                ->join('places AS p', 'q.place_id', '=', 'p.id')      // اولین Inner Join
                ->join('users AS u', 'q.user_id', '=', 'u.id')

                ->select(
                    'q.id',
                    'q.code',
                    'q.is_used',
                    'q.expires_at',
                    'p.name AS place_name',   // نام مکان
                    'u.full_name AS user_name'     // نام کاربر
                )
                ->where('q.place_id', $place_id)
                ->where('q.is_used', false)
                ->where('q.expires_at', '>', now())
                ->get();

            return response()->json($qrCodes);
        }

        // 🚫 خطای دسترسی در صورت عدم تطابق نقش یا مکان
        return response()->json(['message' => 'شما دسترسی به این مکان ندارید.'], 403);


    }

    public function approvedRequests()
    {
        $user = auth()->user();
        $operator = Operator::find($user->id);

        if (!$operator || $operator->role !== 'facility_operator') {
            return response()->json(['message' => 'دسترسی غیرمجاز.'], 403);
        }

        $requests = DB::table('requests AS r')
            ->join('users AS u', 'r.user_id', '=', 'u.id')
            ->join('places AS p', 'r.place_id', '=', 'p.id')
            ->select(
                'r.id',
                'u.full_name AS user_name',
                'u.mobile_number',
                'p.name AS place_name',
                'r.created_at AS requested_at'
            )
            ->where('r.place_id', $operator->place_id)
            ->where('r.status', 'approved')
            ->orderBy('r.created_at', 'desc')
            ->get();

        return response()->json($requests);
    }

}
