<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Operator;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Tymon\JWTAuth\Facades\JWTAuth;

class OperatorAuthController extends Controller
{
    /**
     * ورود اپراتور و دریافت JWT Token
     */
    public function login(Request $request)
    {
        // اعتبارسنجی ورودی‌ها
        $validator = Validator::make($request->all(), [
            'username' => 'required|string',
            'password' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 400);
        }

        // تلاش برای احراز هویت
        $credentials = $request->only('username', 'password');

        if (!$token = Auth::guard('operator_api')->attempt($credentials)) {
            return response()->json(['error' => 'نام کاربری یا رمز عبور اشتباه است'], 401);
        }

        return $this->respondWithToken($token);
    }

    /**
     * دریافت اطلاعات اپراتور لاگین‌شده
     */
    public function me()
    {

        $user = Auth::guard('operator_api')->user();

        // دریافت درخواست‌های کاربر با استفاده از INNER JOIN با جدول places
        $requests = \DB::table('operators')
            ->join('places', 'operators.place_id', '=', 'places.id')
            ->join('facility_categories', 'places.category_id', '=', 'facility_categories.id')
            ->where('operators.id', $user->id)
            ->select('operators.username','facility_categories.name as cat_name', 'operators.place_id', 'places.name as place_name', 'places.latitude', 'places.longitude')
            ->get();

        // تبدیل نتیجه به آرایه

        return response()->json($requests, 200);
    }

    /**
     * خروج اپراتور و باطل‌کردن توکن
     */
    public function logout()
    {
        Auth::guard('operator_api')->logout();
        return response()->json(['message' => 'اپراتور از سیستم خارج شد']);
    }

    /**
     * تمدید توکن JWT
     */
    public function refresh()
    {
        return $this->respondWithToken(Auth::guard('operator_api')->refresh());
    }

    /**
     * فرمت پاسخ برای توکن
     */
    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type'   => 'bearer',
            'expires_in'   => Auth::guard('operator_api')->factory()->getTTL() * 60,
            'operator'     => Auth::guard('operator_api')->user(),
        ]);
    }
}
