<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Place;
use App\Models\FacilityCategory;
use Illuminate\Support\Facades\Validator;

class PlaceController extends Controller
{

    public function index($category_id = null)
    {
        // شروع کوئری
        $query = Place::with('category');

        // اگر category_id ارسال شده باشد، فیلتر کن
        if ($category_id) {
            $query->where('category_id', $category_id);
        }

        // اجرای کوئری و دریافت مکان‌ها
        $places = $query->get();

        return response()->json($places);
    }
    public function getplace($category_id = null)
    {
        // شروع کوئری
        $query = Place::with('category');

        // اگر category_id ارسال شده باشد، فیلتر کن
        if ($category_id) {
            $query->where('category_id', $category_id);
            $query->where('is_active', 1);
        }

        // اجرای کوئری و دریافت مکان‌ها
        $places = $query->get();

        return response()->json($places);
    }


    public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'category_id' => 'required|exists:facility_categories,id',
            'latitude' => 'required|numeric',
            'longitude' => 'required|numeric',
            'is_active' => 'boolean',
        ]);

        $place = new Place([
            'name' => $request->name,
            'category_id' => $request->category_id,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'is_active' => $request->is_active ?? true, // مقدار پیش‌فرض: فعال
        ]);

        $place->save();

        return response()->json([
            'message' => 'مکان جدید با موفقیت اضافه شد',
            'place' => $place
        ], 201);
    }

    public function update(Request $request, $id)
    {
        $place = Place::find($id);
        if (!$place) {
            return response()->json(['error' => 'مکان مورد نظر یافت نشد'], 404);
        }

        $validator = Validator::make($request->all(), [
            'name' => 'sometimes|string|max:255|unique:places,name,' . $id,
            'category_id' => 'sometimes|exists:facility_categories,id',
            'latitude' => 'sometimes|numeric',
            'longitude' => 'sometimes|numeric',
            'is_active' => 'sometimes|boolean',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 400);
        }

        if ($request->has('name')) {
            $place->name = $request->name;
        }
        if ($request->has('category_id')) {
            $place->category_id = $request->category_id;
        }
        if ($request->has('latitude')) {
            $place->latitude = $request->latitude;
        }
        if ($request->has('longitude')) {
            $place->longitude = $request->longitude;
        }
        if ($request->has('is_active')) {
            $place->is_active = $request->is_active;
        }

        $place->save();

        return response()->json([
            'message' => 'مکان با موفقیت به‌روزرسانی شد',
            'place' => $place
        ]);
    }


    public function destroy($id)
    {
        $place = Place::find($id);
        if (!$place) {
            return response()->json(['error' => 'مکان یافت نشد'], 404);
        }

        $place->delete();
        return response()->json(['message' => 'مکان با موفقیت حذف شد']);
    }
}
