<?php

namespace App\Http\Controllers;

use App\Models\Request as UserRequest;
use App\Models\Place;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RequestController extends Controller
{
    public function store(Request $request)
    {
        // دریافت شناسه کاربر لاگین شده
        $user = auth()->user();

        // اعتبارسنجی داده‌های ورودی
        $validator = Validator::make($request->all(), [
            'place_id' => 'required|exists:places,id',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        // بررسی اینکه کاربر قبلاً درخواست ورود برای این مکان را ارسال نکرده باشد
        $existingRequest = UserRequest::where('user_id', $user->id)
            ->where('place_id', $request->place_id)
            ->where(function ($query) {
                $query->where('status', 'pending')
                    ->orWhere('status', 'approved');
            })
            ->first();


        if ($existingRequest) {
            return response()->json(['message' => 'شما برای این مکان رفاهی درخواست فعال دارید'], 400);
        }

        // ثبت درخواست جدید
        $newRequest = UserRequest::create([
            'user_id' => $user->id,
            'place_id' => $request->place_id,
            'status' => 'pending', // وضعیت پیش‌فرض
        ]);

        return response()->json(['message' => 'Request submitted successfully', 'request' => $newRequest], 201);
    }
    public function myRequests()
    {
        // گرفتن کاربر لاگین شده
        $user = auth()->user();

        // دریافت درخواست‌های کاربر با استفاده از INNER JOIN با جدول places
        $requests = \DB::table('requests')
            ->join('places', 'requests.place_id', '=', 'places.id')
            ->where('requests.user_id', $user->id)
            ->orderBy('requests.created_at', 'desc')
            ->select('requests.*', 'places.name as place_name', 'places.latitude', 'places.longitude')
            ->get();

        // تبدیل نتیجه به آرایه

        return response()->json($requests, 200);
        // بازگشت پاسخ JSON

    }




}

