<?php

namespace App\Models;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;

class Operator extends Authenticatable implements JWTSubject
{
    protected $table = 'operators';

    protected $fillable = [
        'username',
        'password_hash',
        'role',
        'place_id',
        'is_active'
    ];

    protected $hidden = [
        'password_hash',
    ];

    // این دو متد برای JWT ضروری هستند
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


    public function place() {
        return $this->belongsTo(Place::class, 'place_id');
    }

    public function getAuthPassword()
    {
        return $this->password_hash;
    }
}
