<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class TemporaryQrCode extends Model
{
    protected $fillable = [
        'user_id',
        'place_id',
        'code',
        'expires_at',
        'is_used',
    ];

    protected $casts = [
        'expires_at' => 'datetime',
        'is_used' => 'boolean',
    ];

    // ارتباط‌ها
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function place()
    {
        return $this->belongsTo(Place::class);
    }
}
