<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Authentication Defaults
    |--------------------------------------------------------------------------
    |
    | این بخش مشخص می‌کند که چه گارد و تنظیماتی به صورت پیشفرض برای احراز هویت استفاده شود.
    | در اینجا گارد پیشفرض را 'api' گذاشته‌ایم که کاربران عادی از طریق JWT لاگین کنند.
    |
    */

    'defaults' => [
        'guard' => 'api', // تغییر از 'web' به 'api'
        'passwords' => 'users',
    ],

    /*
    |--------------------------------------------------------------------------
    | Authentication Guards
    |--------------------------------------------------------------------------
    |
    | در این قسمت تمامی گاردهای احراز هویت مشخص می‌شوند.
    | - 'web' برای کاربران معمولی که با session لاگین می‌کنند.
    | - 'api' برای کاربران اپلیکیشن که از طریق JWT احراز هویت می‌شوند.
    | - 'operator_web' برای اپراتورهای سامانه که در پنل تحت وب با session لاگین می‌کنند.
    | - 'operator_api' برای اپراتورهایی که می‌خواهند از طریق API (مثلاً اپ موبایل) از JWT استفاده کنند.
    |
    */

    'guards' => [
        'web' => [
            'driver' => 'session',
            'provider' => 'users',
        ],

        'api' => [
            'driver' => 'jwt',
            'provider' => 'users',
        ],

        // گارد JWT برای اپراتورها (برای APIهای مربوط به اپراتورها)
        'operator_api' => [
            'driver'   => 'jwt',
            'provider' => 'operators',
        ],

        // گارد وب برای اپراتورها (ورود به پنل تحت وب)
        'operator_web' => [
            'driver'   => 'session',
            'provider' => 'operators',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | User Providers
    |--------------------------------------------------------------------------
    |
    | این قسمت مشخص می‌کند که اطلاعات کاربران از کجا خوانده شوند.
    | - کاربران عادی از جدول `users` خوانده می‌شوند.
    | - اپراتورها از جدول `operators` خوانده می‌شوند.
    |
    */

    'providers' => [
        'users' => [
            'driver' => 'eloquent',
            'model' => App\Models\User::class,
        ],
        'operators' => [
            'driver' => 'eloquent',
            'model'  => App\Models\Operator::class,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Resetting Passwords
    |--------------------------------------------------------------------------
    |
    | تنظیمات مربوط به ریست پسورد در این قسمت تعریف شده است.
    |
    */

    'passwords' => [
        'users' => [
            'provider' => 'users',
            'table' => 'password_resets',
            'expire' => 60,
            'throttle' => 60,
        ],
        'operators' => [
            'provider' => 'operators',
            'table' => 'password_resets',
            'expire' => 60,
            'throttle' => 60,
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Password Confirmation Timeout
    |--------------------------------------------------------------------------
    |
    | مشخص می‌کند که بعد از چند ثانیه تایید پسورد دوباره از کاربر خواسته شود.
    |
    */

    'password_timeout' => 10800,

];
