<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        Schema::create('places', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('category_id')->nullable(); // اضافه کردن نوع صحیح
            $table->decimal('latitude', 10, 7)->nullable();
            $table->decimal('longitude', 10, 7)->nullable();
            $table->boolean('is_active')->default(true);
            $table->timestamps();

            // کلید خارجی به صورت صحیح تعریف شود
            $table->foreign('category_id')->references('id')->on('facility_categories')->onDelete('set null');
        });

    }

    public function down()
    {
        Schema::dropIfExists('places');
    }
};

