<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\RequestController;
use App\Http\Controllers\OperatorAuthController;
use App\Http\Controllers\OperatorRequestController;
use App\Http\Controllers\FacilityCategoryController;
use App\Http\Controllers\PlaceController;
use App\Http\Controllers\QrCodeController;
use App\Http\Controllers\EntryController;
use App\Http\Controllers\FacilityManagerController;
use App\Http\Controllers\UserAppController;
use App\Http\Controllers\OperatorController;
use App\Http\Controllers\OperatorDashboardController;
use App\Http\Controllers\DashboardController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});



Route::post('/login', [AuthController::class, 'login']);
Route::post('/register', [AuthController::class, 'register']);
Route::middleware('auth:api')->get('/me', [AuthController::class, 'me']);
Route::middleware('auth:api')->post('/logout', [AuthController::class, 'logout']);
Route::middleware('auth:api')->post('/requests', [RequestController::class, 'store']);
Route::middleware('auth:api')->get('/my-requests', [RequestController::class, 'myRequests']);
Route::middleware('auth:api')->post('/generate-qr', [QrCodeController::class, 'generate']);
Route::middleware('auth:api')->get('/categories', [FacilityCategoryController::class, 'index']);
Route::middleware('auth:api')->get('/places/{category_id?}', [PlaceController::class, 'getplace']);
Route::middleware('auth:api')->post('/entries', [EntryController::class, 'store']);
Route::middleware('auth:api')->get('/dashboard', [DashboardController::class, 'userDashboard']);





Route::group(['prefix' => 'operator'], function () {
    Route::post('/login', [OperatorAuthController::class, 'login']);

    Route::group(['middleware' => 'auth:operator_api'], function () {
        Route::post('/logout', [OperatorAuthController::class, 'logout']);

        Route::post('/refresh', [OperatorAuthController::class, 'refresh']);
    });
});

Route::middleware(['auth:operator_api'])->group(function () {
    Route::get('/operator/info', [OperatorAuthController::class, 'me']);

});

Route::middleware(['auth:operator_api'])->group(function () {
    Route::get('/operator/facility-qr-codes/{place_id}', [FacilityManagerController::class, 'showQrCodes']);
    Route::get('/operator/approved-requests', [FacilityManagerController::class, 'approvedRequests']);
});


Route::middleware(['auth:operator_api'])->group(function () {
    Route::get('/operator/requests', [OperatorRequestController::class, 'listRequests']);
    Route::post('/operator/approve-request', [OperatorRequestController::class, 'approveRequest']);
    Route::post('/operator/reject-request', [OperatorRequestController::class, 'rejectRequest']);
});



Route::middleware(['auth:operator_api'])->group(function () {
    Route::get('/operator/categories', [FacilityCategoryController::class, 'index']); // دریافت لیست دسته‌بندی‌ها
    Route::post('/operator/categories', [FacilityCategoryController::class, 'store']); // ایجاد دسته‌بندی جدید
    Route::put('/operator/categories/{id}', [FacilityCategoryController::class, 'update']); // ویرایش دسته‌بندی
    Route::delete('/operator/categories/{id}', [FacilityCategoryController::class, 'destroy']); // حذف دسته‌بندی
});




Route::middleware(['auth:operator_api'])->group(function () {
    Route::get('/operator/places/{category_id?}', [PlaceController::class, 'index']);  // لیست مکان‌ها
    Route::post('/operator/places', [PlaceController::class, 'store']); // ایجاد مکان جدید
    Route::put('/operator/places/{id}', [PlaceController::class, 'update']); // ویرایش
    Route::delete('/operator/places/{id}', [PlaceController::class, 'destroy']); // حذف
});

Route::middleware(['auth:operator_api'])->group(function () {
    Route::get('/operator/userapp', [UserAppController::class, 'index']); // لیست
    Route::put('/operator/userapp/{id}/toggle-status', [UserAppController::class, 'toggleStatus']); // فعال/غیرفعال
    Route::delete('/operator/userapp/{id}', [UserAppController::class, 'destroy']); // حذف
    Route::put('/operator/userapp/{id}', [UserAppController::class, 'update']); // ویرایش ✅
});
Route::middleware(['auth:operator_api'])->group(function () {
    Route::get('/operator/operators', [OperatorController::class, 'index']);
    Route::post('/operator/operators', [OperatorController::class, 'store']);
    Route::put('/operator/operators/{id}', [OperatorController::class, 'update']);
    Route::put('/operator/operators/{id}/toggle-status', [OperatorController::class, 'toggleStatus']);
    Route::delete('/operator/operators/{id}', [OperatorController::class, 'destroy']);
    Route::put('/operator/operators/{id}/change-password', [OperatorController::class, 'changePassword']);
});
Route::middleware(['auth:operator_api'])->get('/operator/dashboard-stats', [OperatorDashboardController::class, 'stats']);
