<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\TemporaryQrCode;
use App\Models\Request as RequestModel;

class QrCodeController extends Controller
{
    public function generate(Request $request) {
        $request->validate([
            'place_id' => 'required|exists:places,id',
            'entry_type' => 'required|in:entry,exit',
        ]);

        $user = auth()->user();

        // بررسی اینکه آیا درخواست فعال قبلی وجود دارد یا نه
        $existingQr = TemporaryQrCode::where('user_id', $user->id)
            ->where('place_id', $request->place_id)
            ->where('is_used', false)
            ->where('expires_at', '>', now())
            ->first();

        if ($existingQr) {
            return response()->json([
                'message' => 'کد قبلی هنوز فعال است.',
                'qr_code' => $existingQr->code,
                'expires_at' => $existingQr->expires_at
            ], 200);
        }

        // تولید QR Code جدید
        $qrCode = new TemporaryQrCode();
        $qrCode->user_id = $user->id;
        $qrCode->place_id = $request->place_id;
        $qrCode->code = Str::random(10);
        $qrCode->expires_at = now()->addMinutes(2);
        $qrCode->is_used = false;
        $qrCode->save();

        return response()->json([
            'message' => 'کد جدید تولید شد.',
            'qr_code' => $qrCode->code,
            'expires_at' => $qrCode->expires_at
        ], 201);
    }

}
