<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;

class UserAppController extends Controller
{
    public function index()
    {
        return User::select('id', 'full_name', 'personnel_code', 'mobile_number','device_id', 'is_active', 'created_at')->get();
    }

    public function update(Request $request, $id)
    {
        $user = User::findOrFail($id);

        $request->validate([
            'full_name' => 'required|string|max:255',
            'mobile_number' => 'required|string|max:255|unique:users,mobile_number,' . $id,
            'personnel_code' => 'required|string|max:255|unique:users,personnel_code,' . $id,
            'device_id' => 'nullable|string|max:255',
        ]);

        $user->update([
            'full_name' => $request->full_name,
            'mobile_number' => $request->mobile_number,
            'personnel_code' => $request->personnel_code,
            'device_id' => $request->device_id,
        ]);

        return response()->json(['message' => 'کاربر با موفقیت ویرایش شد.']);
    }

    public function toggleStatus($id)
    {
        $user = User::findOrFail($id);
        $user->is_active = !$user->is_active;
        $user->save();

        return response()->json(['message' => 'وضعیت کاربر تغییر کرد.']);
    }

    public function destroy($id)
    {
        $user = User::findOrFail($id);

        // بررسی: آیا کاربر دارای درخواست هست؟
        if ($user->requests()->exists()) {
            return response()->json([
                'message' => 'این کاربر دارای درخواست ثبت‌شده است و نمی‌توان او را حذف کرد.'
            ], 400);
        }

        $user->delete();

        return response()->json(['message' => 'کاربر با موفقیت حذف شد.']);
    }

}

