<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Place extends Model
{
    use HasFactory;

    protected $fillable = ['name', 'category_id', 'latitude', 'longitude', 'is_active'];

    protected $casts = [
        'latitude' => 'float',
        'longitude' => 'float',
        'is_active' => 'boolean',
    ];

    /**
     * ارتباط با دسته‌بندی امکانات رفاهی
     */
    public function category()
    {
        return $this->belongsTo(FacilityCategory::class, 'category_id');
    }

    /**
     * ارتباط با درخواست‌های ورود کاربران
     */
    public function requests()
    {
        return $this->hasMany(Request::class, 'place_id');
    }
}
